﻿using System;
using System.Globalization;
using System.Linq;


public class ConvertHelpers
{
    public static string HexConvertToString(byte[] buf, String space) //prints byte array as string
    {
        String ret = "";
        for (int i = 0; i < buf.Length; i++)
            ret += ((char) buf[i]).ToString(CultureInfo.InvariantCulture);
        return ret;
    }

    public static byte[] ConvertHexStringToByteArray(string hexString)
    {
        if (hexString.Length%2 != 0)
        {
            throw new ArgumentException(String.Format(CultureInfo.InvariantCulture,
                                                      "The binary key cannot have an odd number of digits: {0}",
                                                      hexString));
        }

        var hexAsBytes = new byte[hexString.Length/2];
        for (int index = 0; index < hexAsBytes.Length; index++)
        {
            string byteValue = hexString.Substring(index*2, 2);
            hexAsBytes[index] = byte.Parse(byteValue, NumberStyles.HexNumber, CultureInfo.InvariantCulture);
        }

        return hexAsBytes;
    }


    public static string ConvertByteArrayToHexString(byte[] buf)
    {
        return buf.Aggregate("", (current, t) => current + string.Format("{0:X2}", t));
    }
}

